#ifndef _TABSERVER_H
#define _TABSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabServerDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND ListenPort_hWnd;
    static HWND MaxClients_hWnd;
    static HWND NextClientID_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        ListenPort_hWnd   = GetDlgItem(xHandle, IDC_LISTENPORT);
        MaxClients_hWnd   = GetDlgItem(xHandle, IDC_MAXCONNECTS);
		NextClientID_hWnd = GetDlgItem(xHandle, IDD_NEXTCLIENTID);

		Set_Long(ListenPort_hWnd, giListenPort);
        Set_Long(MaxClients_hWnd, giMaxClients);
        Set_Long(NextClientID_hWnd, giNextClientID);

		if(gbDropBadPackets)
			CheckDlgButton(xHandle, IDD_DROPBADPACKETS, BST_CHECKED);

		if(gbPacketMode)
			CheckDlgButton(xHandle, IDC_USEPACKEMODE, BST_CHECKED);

		if(gbUseCompression)
			CheckDlgButton(xHandle, IDC_USECOMPRESSION, BST_CHECKED);
		
		return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
